//********************************************************************************
//								     Include
//********************************************************************************
#include "MDSF05_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"
//********************************************************************************
//								       RAM
//********************************************************************************
//The variables defined by data are placed in the first 128 bytes (0x00~0x7F) address space
//The variables defined by idata are placed in the (0x00~0xFF) address space
//The variable defined by xdata are placed in the external extended RAM  (generally refers to the external 0xF000~0xF1FF space, the specific space size varies with the MCU , and some MCU do not have external RAM)

//The variable defined by data is the fastest, followed by idata, and xdata is slower than the first two
//Variables that are often used are declared with data/idata; variables that are not commonly used are declared with xdata.

//********************************************************************************
//						    		  LPF
//********************************************************************************
// signed int LPF_Function(signed int LPF_IN,signed int LPF_LAST_OUT,signed int Gain){
// signed int LPF_OUT;
	// LPF_GAIN_MACRO(Gain);
	// LPF_IN_MACRO(LPF_IN);
	// LPF_LAST_OUT_MACRO(LPF_LAST_OUT);
	// LPF_Active;
	// _nop_();_nop_();_nop_();_nop_();_nop_();
	// GET_LPF_OUT(LPF_OUT);
	// return LPF_OUT;
// }
//********************************************************************************
//						    		Ramp
//********************************************************************************
short Ramp_Fun (short TargetValue,SetpointValue,HighLimit,LowLimit,SetpValue){
	if(TargetValue != SetpointValue){
		if(TargetValue >= SetpointValue){
			SetpointValue += SetpValue;
			if(SetpointValue >= TargetValue)
				SetpointValue = TargetValue;
		}
		else{
			SetpointValue -= SetpValue;
			if(SetpointValue <= TargetValue)
				SetpointValue = TargetValue;
		}
	}
	
	if(SetpointValue > HighLimit)
		SetpointValue = HighLimit;
	else if(SetpointValue < LowLimit)
		SetpointValue = LowLimit;

	return SetpointValue;
}
//********************************************************************************
//						    First-order linear formula
//********************************************************************************
#if (DCR_Strategy == 1)
unsigned int LERP(unsigned int g,unsigned int a,unsigned int fa, unsigned int b,unsigned int fb){
	//return (b == a) ? fa : fa + (((signed long)(fb-fa) * ((g-a)) / (b-a)));
	//return  fa + ((fb-fa) * ((x-a) / (b-a)));
	
	fa =  fa + ((unsigned long int)((unsigned long int)(((unsigned long int)(fb-fa)) * ((unsigned long int)(g-a)))) / ((unsigned long int)(b-a)));
	//fa = 728 + (((unsigned long)(971-728)*(350-300)) / (400-300));
	return fa;
	/* 																					y  o(b,fb)
	First step linearity: given a certain two coordinates, the slope can be obtained. Substitute any axis value on this slope to obtain another axis value.			|		  .   
	Ex: Taking the variables above as examples (a, fa), (b, fb) are two known coordinates						  return fa	|	
		Assuming g is any point on the x-axis, and the return fa is the y-axis corresponding to g on this slope.	
																						| o(a,fa)
																						|_______________x
																								g
	*/																								
}
#endif
